// 
// Decompiled by Procyon v0.5.36
// 

package ORG.oclc.oai.harvester.crosswalk;

import javax.xml.transform.TransformerException;
import ORG.oclc.oai.harvester.verb.CannotCrosswalkFormatException;
import javax.xml.transform.Result;
import java.io.Writer;
import javax.xml.transform.stream.StreamResult;
import java.io.StringWriter;
import java.io.Reader;
import java.io.StringReader;
import ORG.oclc.oai.harvester.verb.Record;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import java.io.FileInputStream;
import java.util.Properties;
import javax.xml.transform.Transformer;

public class XSLTCrosswalk extends Crosswalk
{
    private Transformer transformer;
    
    public XSLTCrosswalk(final Properties properties) throws IllegalArgumentException {
        super(properties.getProperty("XSLTCrosswalk.schemaLocation"));
        this.transformer = null;
        final String xsltPath = properties.getProperty("XSLTCrosswalk.xsltPath");
        if (xsltPath != null) {
            try {
                final StreamSource xslSource = new StreamSource(new FileInputStream(xsltPath));
                final TransformerFactory tFactory = TransformerFactory.newInstance();
                this.transformer = tFactory.newTransformer(xslSource);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    
    public boolean isAvailableFor(final Record record) {
        return true;
    }
    
    public Object toItem(final Record record) throws CannotCrosswalkFormatException {
        String xmlRec = record.getMetadata();
        if (this.transformer == null) {
            return xmlRec;
        }
        if (xmlRec.startsWith("<?")) {
            final int offset = xmlRec.indexOf("?>");
            xmlRec = xmlRec.substring(offset + 2);
        }
        final StringReader stringReader = new StringReader(xmlRec);
        final StreamSource streamSource = new StreamSource(stringReader);
        final StringWriter stringWriter = new StringWriter();
        try {
            this.transformer.transform(streamSource, new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new CannotCrosswalkFormatException();
        }
    }
}
